/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package printing;

/** 
 * @author Matthew Gregory
 * website: www.matthewgregory-author.com.au
 *
 */
public class Person {

    public String firstName;
    public String lastName;
    public final int ID;
    public int age;
    
    //Constructor with two arguements
    public Person(String firstName, String lastName) {
        setNames(firstName,lastName);
        ID=hashCode();
    }

    public String getFullName(){
        return firstName+" "+lastName;
    }
    
    public void printDetails(){
        System.out.println("ID: "+ID);
        System.out.println("First Name: "+firstName);
        System.out.println("Last Name: "+lastName);
        System.out.println("Age: "+age);
        System.out.println("Full Name: "+getFullName());
    }
    
//    public String toString(){
//        return getFullName();
//    }

    public void setNames(String firstName, String lastName){
        this.firstName = firstName;
        this.lastName = lastName;
    }  
    
    //Overloading setNames with a single parameter version
    public void setNames(String firstName){
        this.firstName = firstName;
    }  
    
    //Overloading setNames with a no parameter version
    public void setNames(){
        this.firstName = null;
        this.lastName = null;
    } 
    
    //Overloading setField with same number of parameters but different data types
    //This method accepts a string and changes the firstName
    public void setField(String name){
        firstName = name;
    }
    //This method accepts an int and changes the age
    public void setField(int age){
        this.age=age;
    }
    
    //Overloading only works if the parameters are different.
    //Method to get the persons first name.
    public String getField(){
        return firstName;
    }
    //Method to get the persons age. (will not compile)
//    public int getField(){
//        return age;
//    }
}
